# CSVファイルをDataTablesを使ったHTMLファイルを出力する
# DataTables: https://datatables.net/

import argparse
import pandas as pd
import json


def main():
	parser = argparse.ArgumentParser(description="csv2html")
	parser.add_argument("files", nargs="*", help="CSV files")
	parser.add_argument("--page_length", type=int, default=50, help="Number of records per page")
	args = parser.parse_args()

	for file in args.files:
		output_datatables2(file, args.page_length)

def output_datatables(file):
	df = pd.read_csv(file)
	data = df.to_dict(orient='records')
	data_json = json.dumps(data)

	html = f"""
	<!DOCTYPE html>
	<html>
	<head>
		<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.20/css/jquery.dataTables.css">
		<script type="text/javascript" charset="utf8" src="https://code.jquery.com/jquery-3.3.1.js"></script>
		<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.20/js/jquery.dataTables.js"></script>
	</head>
	<body>
		<table id="table_id" class="display">
			<thead>
				<tr>
					{"".join([f"<th>{col}</th>" for col in df.columns])}
				</tr>
			</thead>
		</table>
		<script type="text/javascript">
			$(document).ready( function () {{
				$('#table_id').DataTable({{
					data: {data_json},
					columns: {json.dumps([{"data": col, "title": col} for col in df.columns])}
				}});
			}} );
		</script>
	</body>
	</html>
	"""

	with open(f"{file}.html", "w") as f:
		f.write(html)

def output_datatables2(file, page_length):
	df = pd.read_csv(file)
	data = df.to_dict(orient='records')
	data_json = json.dumps(data)

	html = f"""
	<!DOCTYPE html>
	<html>
	<head>
		<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.20/css/jquery.dataTables.css">
		<script type="text/javascript" charset="utf8" src="https://code.jquery.com/jquery-3.3.1.js"></script>
		<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.20/js/jquery.dataTables.js"></script>
	</head>
	<body>
		<table id="table_id" class="display">
			<thead>
				<tr>
					{"".join([f"<th>{col}</th>" for col in df.columns])}
				</tr>
			</thead>
		</table>
		<script type="text/javascript">
			$(document).ready( function () {{
				$('#table_id').DataTable({{
					data: {data_json},
					columns: {json.dumps([{"data": col, "title": col} for col in df.columns])},
					pageLength: {page_length}
				}});
			}} );
		</script>
	</body>
	</html>
	"""

	with open(f"{file}.html", "w") as f:
		f.write(html)

if __name__ == "__main__":
	main()
