
# Google Map API v2 -> v3
#

import argparse
import re
import os
from datetime import datetime

APIKey = 'AIzaSyA7A2KHvBRGshzYiy5DnNHfmpJREfomS2I'

replaces = {
    'GMap2':'google.maps.Map',
    'GLatLng':'google.maps.LatLng',
    'GInfoWindow':'google.maps.InfoWindow',
    'GMapOptions':'google.map.MapOptions',
    'G_API_VERSION':'google.maps.version',
    'GPolyStyleOptions':'google.maps.PolygonOptions',
    ' onunload="GUnload()"':'',
    'GDownloadUrl': 'XDownloadUrl',
    # program depends
    '.encoded_points': '["encoded_points"]',
}

obsoletes = [
'GBounds',
'GLanguage',
'GBrowserIsCompatible',
'GLayer',
'GControl',
'GLog',
'GControlAnchor',
'GMercatorProjection',
'GControlImpl',
'GNavLabelControl',
'GControlPosition',
'GObliqueMercator',
'GCopyright',
'GOverlay',
'GCopyrightCollection',
'GPhotoSpec',
'GDownloadUrl',
'GPolyEditingOptions',
'GDraggableObject',
'GScreenOverlay',
'GDraggableObjectOptions',
'GStreetviewFeatures',
'GFactualGeocodeCache',
'GStreetviewLocation',
'GGeoAddressAccuracy',
'GStreetviewOverlay',
'GGeocodeCache',
'GStreetviewUserPhotosOptions',
'GGoogleBar',
'GTileLayerOptions',
'GGoogleBarAdsOptions',
'GTileLayerOverlayOptions',
'GGoogleBarLinkTarget',
'GTrafficOverlayOptions',
'GGoogleBarListingTypes',
'GUnload',
'GGoogleBarOptions',
'GXml',
'GGoogleBarResultList',
'GXmlHttp',
'GInfoWindowTab',
'GXslt',
'GKeyboardHandler',
]


def main():
    parser = argparse.ArgumentParser(description="gm2to3")
    parser.add_argument("files", nargs="*")
    parser.add_argument('-r', '--replace', action='store_true', help='replace original file to new file')
    parser.add_argument('-b', '--backup', action='store_true', help='overwrite and backup original file')
    args = parser.parse_args()

    for file in args.files:
        base, ext = os.path.splitext(file)
        newfile = base + '_new' + ext

        if not os.path.exists(file):
            print("Not found file:", file)
            continue

        print("writing...",newfile)

        if ext == '.html':
            cvt_html(file, newfile)
        elif ext == '.js':
            if not cvt_js(file, newfile):
                os.remove(newfile)
                print("already converted:", file)
                continue
        elif ext == '.json':
            cvt_json(file, newfile)
        else:
            print("Unknown extesion", ext)
            exit(1)

        if args.backup:
            bakfile = file + '.bak'
            if os.path.exists(bakfile):
                os.remove(bakfile)
            os.rename(file, bakfile)
            os.rename(newfile, file)
        elif args.replace:
            os.remove(file)
            os.rename(newfile, file)
            print("overwrite", file)

def cvt_html(file, newfile):
    # may be maps.html file
    fw = open(newfile, mode='w', encoding='utf8')
    i = 0
    for line in open(file, 'r', encoding='utf8'):
        # print(line)
        if '<script src="http://maps.google.com/maps?file=api' in line:
            # replace with v3 API
            line = 	'   <script type="text/javascript" src="//maps.googleapis.com/maps/api/js?libraries=geometry&key='+APIKey+'"></script>\n'
        elif '<script type="text/javascript" src="http://www.google.com/jsapi' in line:
            # remove
            continue
        elif '<script type="text/javascript">google.load("jquery"' in line:
            # replace slightly upper version of jQuery
            line = '	<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>\n'
        elif 'onunload="GUnload()"' in line:
            line = re.sub(r'onunload="GUnload\(\)" ', '', line)

        # print(line)
        i += 1
        fw.write(line)

remove_lines = [
'var Icon = new GIcon();',
'Icon.image = "http://labs.google.com/ridefinder/images/mm_20_red.png";',
'Icon.shadow = "http://labs.google.com/ridefinder/images/mm_20_shadow.png";',
'Icon.iconSize = new GSize(12, 20);',
'Icon.shadowSize = new GSize(22, 20);',
'Icon.iconAnchor = new GPoint(6, 20);',
'Icon.infoWindowAnchor = new GPoint(5, 1);',
'Icon.image = "http://www.google.com/mapfiles/dd-start.png";',
'Icon.shadow = "http://www.google.com/mapfiles/shadow50.png";',
'Icon.iconSize = new GSize(20, 34);',
'Icon.shadowSize = new GSize(37, 34);',
'Icon.iconAnchor = new GPoint(9, 34);',
'Icon.infoWindowAnchor = new GPoint(9, 2);',
]

replace_lines = {
'GEvent.addListener(photo_markers[posofphotos], "click", function(){jumpphotomarker(nn);});': 'google.maps.event.addListener(photo_markers[posofphotos], "click", function(){jumpphotomarker(nn);});',
'map.addOverlay(photo_markers[posofphotos]);': 'photo_markers[posofphotos].setMap(map);',
'GEvent.addListener(waypoint_markers[posofwaypoints], "click",function(){jumpwaypointmarker(nn);});': 'google.maps.event.addListener(waypoint_markers[posofwaypoints], "click", function(){jumpwaypointmarker(nn);});',
'map.addOverlay(waypoint_markers[posofwaypoints]);': 'waitpoint_markers[posofwaypoints].setMap(map);',
'ie6 : $.browser.msie && $.browser.version < 7.0,': 'ie6 : false,'
}

# かなり複雑。かといって、必要なデータを吸い上げて作り直すというのも・・・
def cvt_js(file, newfile):
    # may be gmapmgr.js file
    fw = open(newfile, mode='w', encoding='utf8')
    i = 0
    delete_mode = 0
    for line in open(file, 'r', encoding='utf8'):

        if i == 2:
            if 'Converted from v2 to v3' in line:
                # already converted
                return False
            fw.write('// Converted from v2 to v3. {}\n'.format(datetime.now()))

        if delete_mode > 0:
            if delete_mode == 1:
                if '});' in line:
                    delete_mode = 0
                continue

            if delete_mode == 2:
                if 'map.setMapType(G_NORMAL_MAP);' in line:
                    delete_mode = 21
                continue

            if delete_mode == 21:
                if '	}\n' == line:
                    delete_mode = 0
                    fw.write('''\
	var _zoom = zoom
	if (zoom>0)
	{
		_zoom = 17-zoom;
	}

	// 初期マップタイプ設定
	var mapTypeId = google.maps.MapTypeId.ROADMAP;
	switch(defaultmaptype)
	{
		case 1:
		// map.setMapType(G_SATELLITE_MAP); //This map type shows Google Earth satellite images.
		mapTypeId = google.maps.MapTypeId.SATELLITE;
		break;
	
		case 2:
		// map.setMapType(G_HYBRID_MAP); 	//This map type shows transparent street maps over Google Earth satellite images.
		mapTypeId = google.maps.MapTypeId.HYBRID;
		break;
		
		case 3:
		// map.setMapType(G_PHYSICAL_MAP);
		mapTypeId = google.maps.MapTypeId.TERRAIN;
		break;		
	}

	var mapOptions = {
        zoom: _zoom,
        center: centerpos,
        scaleControl: true,
        overviewMapControl: true,
        overviewMapControlOptions:{opened:true},
        mapTypeId: mapTypeId,
        gestureHandling: 'greedy'
	};
	map = new google.maps.Map(document.getElementById("map"), mapOptions);
	if (zoom <= 0){
		map.fitBounds(region);
	}
	InitStreetView();
''')
                continue

            if delete_mode == 4:
                if 'try' in line:
                    delete_mode = 41
                    fw.write('''\
    jsondata = jsontext;
''')
                    continue
                else:
                    pass    # output this line
            elif delete_mode == 41:
                if line == '	}\n':
                    delete_mode = 0
                continue

            elif delete_mode == 5:
                if 'map.addOverlay(encodedPolyline);' in line:
                    fw.write('''\
	var decodedPath = google.maps.geometry.encoding.decodePath(jsondata["encoded_points"][polylineid]);
	var decodedLevels = decodeLevels(jsondata["encoded_levels"][polylineid]);

	var polyline = new google.maps.Polyline({
        path: decodedPath,
        levels: decodedLevels,
        strokeColor: jsondata.linecolors[polylineid],
        strokeOpacity: jsondata.lineopacities[polylineid],
		strokeWeight: jsondata.linewidth[polylineid],
		zoomFactor: 4,
		numLevels: 9,
        map: map
    });
''')
                    delete_mode = 0
                continue

            elif delete_mode == 7:
                if 'map.addOverlay(moveMarker);' in line:
                    delete_mode = 0
                    fw.write('''\
			var properties = {
				position: gcurrent,
				map: map,
				title: "Move Marker",
				icon: "http://maps.google.co.jp/mapfiles/ms/icons/hospitals.png",
				shadow: "http://maps.google.co.jp/mapfiles/ms/icons/hospitals.shadow.png"
			};
			moveMarker = new google.maps.Marker(properties);
			moveMarker.setMap(map)
''')
                continue

            elif delete_mode == 8:
                if 'if (n < 1) return;' in line:
                    delete_mode = 81
            elif delete_mode == 81:
                if line == '}\n':
                    delete_mode = 0
                    fw.write('''
	var info = photo_infos[n-1];
	var marker = photo_markers[n-1];
	if (infoWindow != null) infoWindow.close();	// not allowed multi window
	infoWindow = new google.maps.InfoWindow();
	infoWindow.setContent(info);
	infoWindow.open(map, marker);
	location.hash="#googlemap";
    moveSVLocationLatLon(marker.getPosition());
''')
                else:
                    continue

            elif delete_mode == 9:
                if line == '{\n':
                    delete_mode = 91
            elif delete_mode == 91:
                if line == '}\n':
                    delete_mode = 0
                    fw.write('''\
	var info = waypoint_infos[n-1];
	var marker = waypoint_markers[n-1];
	if (infoWindow != null) infoWindow.close();	// not allowed multi window
	infoWindow = new google.maps.InfoWindow();
	infoWindow.setContent(info);
	infoWindow.open(map, marker);
	location.hash="#googlemap";
	moveSVLocationLatLon(marker.getPosition());
''')
                else:
                    continue

            else:
                continue

        # print(line)
        if 'photo_markers.push(new GMarker(point, Icon));' in line:
            fw.write('''\
		var properties = {
			position: point,
			map: map,
			title:"Waypoint Marker",
			icon:"http://labs.google.com/ridefinder/images/mm_20_red.png",
			shadow:"http://labs.google.com/ridefinder/images/mm_20_shadow.png"
		};
		var marker = new google.maps.Marker(properties);
	
		photo_markers.push(marker);
''')
            continue
        elif 'waypoint_markers.push(new GMarker(point, Icon));' in line:
            fw.write('''\
		var properties = {
			position: point,
			map: map,
			title:"Waypoint Marker",
			icon:"http://www.google.com/mapfiles/dd-start.png",
			shadow:"http://www.google.com/mapfiles/shadow50.png"
		};
		var marker = new google.maps.Marker(properties);
	
		waypoint_markers.push(marker);
''')
            continue


        # 単一行の削除
        no_out = False
        for key in remove_lines:
            if key in line:
                no_out = True
                break
        if no_out:
            continue

        # 単一行の一部の置換
        for old, new in replace_lines.items():
            if old in line:
                line = line.replace(old, new)
                break

        # 複数行の削除・置換
        if 'streetObj = new GStreetviewPanorama(document.getElementById("streetview"));' in line:
            delete_mode = 1
            continue

        elif 'map = new GMap2(document.getElementById("map"));' in line:
            delete_mode = 2
            continue

        elif 'function loadTrackLog(jsontext, statusCode)' in line:
            delete_mode = 4

        elif 'var encodedPolyline = new GPolyline.fromEncoded({' in line:
            delete_mode = 5
            continue

        elif 'moveMarker = new GMarker(gcurrent, movemarkerIcon);' in line:
            delete_mode = 7
            continue

        elif 'function jumpphotomarker(n)' in line:
            delete_mode = 8
            fw.write('''\
var infoWindow;
''')

        elif 'function jumpwaypointmarker(n)' in line:
            delete_mode = 9

        if 'var key =' in line:
            line = 'var key = "'+APIKey+'";\n'

        for old, new in replaces.items():
            line = line.replace(old, new)
        linec = re.sub(r'//.+', '', line)
        for key in obsoletes:
            if key in linec:
                print("ERR: obsolete word in line", i+1)

        # line.encode('cp932')
        # print(line)
        i += 1
        fw.write(line)

    # 追加関数
    fw.write('''\
function XDownloadUrl(url, func)
{
	$.ajax({
	  url: url,
	  cache: false,
	  dataType: "json",
	}).done(function(data, status, xhr){
		func(data, xhr.status);
	}).fail(function(xhr, status, error){
		alert("failed "+xhr.status + " "+xhr.statusText+" "+url+" status="+status+" error="+error);
		});
}
// Decode an encoded levels string into an array of levels.
function decodeLevels(encodedLevelsString)
{
  var decodedLevels = [];

  for (var i = 0; i < encodedLevelsString.length; ++i) {
    var level = encodedLevelsString.charCodeAt(i) - 63;
    decodedLevels.push(level);
  }

  return decodedLevels;
}
''')

    return True

# data.json formatには間違いがある！！
def cvt_json(file, newfile):
    # may be data.json file
    fw = open(newfile, mode='w', encoding='utf8')
    i = 0
    prev = ''
    prev_org = ''
    for line in open(file, 'r', encoding='utf8'):
        if line == '\n':
            continue
        if prev:
            if re.match(r'^]', line):
                fw.write(prev)
            else:
                fw.write(prev_org)

        prev = re.sub(r', *$', '', line)
        if prev != line:
            prev_org = line
            continue

        prev = ''
        i += 1
        fw.write(line)


main()
