# 国土地理院 1003山データをTSVに変換
# https://www.gsi.go.jp/kihonjohochousa/kihonjohochousa41192.html


hp = [
	'https://www.gsi.go.jp/kihonjohochousa/kihonjohochousa41188.html',	# >=3500
	'https://www.gsi.go.jp/kihonjohochousa/kihonjohochousa41189.html',	# >=3000
	'https://www.gsi.go.jp/kihonjohochousa/kihonjohochousa41190.html',
	'https://www.gsi.go.jp/kihonjohochousa/kihonjohochousa41191.html',	# >=2000
	'https://www.gsi.go.jp/kihonjohochousa/kihonjohochousa41192.html',
	'https://www.gsi.go.jp/kihonjohochousa/kihonjohochousa41193.html',	# >=1000
	'https://www.gsi.go.jp/kihonjohochousa/kihonjohochousa41194.html',
	'https://www.gsi.go.jp/kihonjohochousa/kihonjohochousa41195.html'
]

import re
import urllib.request

def main():
	download = False
	if download:
		for i, url in enumerate(hp):
			file = "mt1003-{}.html".format(i)
			urllib.request.urlretrieve(url, file)

	for i in range(len(hp)):
		file = "mt1003-{}.html".format(i)
		parseHtml(file)

#Note: えぶりさしだけ と やくらいさん は画像を使っているので手作業での変換が必要
def parseHtml(file):
	found = False
	for line in open(file, encoding='utf8'):
		if not found:
			if 'class="base_txt"' in line:
				found = True
		else:
			# <tr><td>ちえんべつだけ<br><a href="https://maps.gsi.go.jp/#15/44.124722222222225/145.1686111111111" target="_blank">知円別岳</a></td><td>知床・阿寒</td><td align="right">1544m</td><td nowrap align="right" >44度07分29秒<br>145度10分07秒</td><td>標高点</td><td></td></tr>
			m = re.match(r'.*>(.+)<\/a>.+>(\d+)m.+>(\d+)度(\d+)分(\d+)秒<br>(\d+)度(\d+)分(\d+)秒', line)
			if m:
				name = m.group(1)
				alt = m.group(2)
				lat = toDegree(m.group(3), m.group(4), m.group(5))
				lng = toDegree(m.group(6), m.group(7), m.group(8))
				# m = re.match(r'(.+)<(.+)>', name)
				# if m:
				# 	name = m.group(1)
				# 	subname = m.group(2)
				# m = re.match(r'(.+)（(.+)）', name)
				# if m:
				# 	name = m.group(1)
				# 	subname = m.group(2)
				s = '\t'.join([name, alt, str(lat), str(lng)])
				print(s)

def toDegree(d, m, s):
	return int(d) + int(m)/60 + int(s)/3600



main()
