

import argparse
from ctypes.wintypes import tagRECT
import datetime
import glob
import os
import re
import json

import t2g3lib

CarVelocity = 15	# [km/h] 平均速度がこれ以上は自動車

def main():
	parser = argparse.ArgumentParser(description="t2g3out")
	parser.add_argument('-o', '--output', help='file name to output (csv format)')
	parser.add_argument('-m', '--month', help='file name to output monthly statistics (csv format)')
	parser.add_argument('-mg', '--month_graph', help='file name to output monthly statistics as graph (png image file)')
	parser.add_argument('-c', '--only_car', action='store_true')
	parser.add_argument('-x', '--except_car', action='store_true')
	parser.add_argument('-t', '--find_title', help='find title in index.html')
	args = parser.parse_args()

	target_dirs = []

	# 対象ディレクトリの検索
	dirs = glob.glob('./*')
	for dir in dirs:
		if os.path.isdir(dir):
			file = os.path.join(dir, 'maps.files', 'vars.json')
			if os.path.exists(file):
				target_dirs.append(dir)

	# print(target_dirs)

	titles = {}
	if args.find_title:
		if os.path.exists(args.find_title):
			titles = read_index(args.find_title)

	total_cost = 0

	f = None
	if args.output:
		f = open(args.output, mode='w', encoding='utf-8')

	out = "Directory,Title,StartTime,EndTime,移動時間,実移動時間,移動距離,累積上り高度,累積下り高度,コース定数,コースタイム,消費カロリー,費用,実平均速度,平均速度,相対高度差,最大高度,最小高度,累積高度差,累積上り時間,累積下り時間,上り水平距離,下り水平距離,平均上り速度,平均下り速度,ピーク数,TimeRatio,TimeRatioPerc,ActualTimeRatio,ActualTimeRatioPerc"
	if args.output:
		f.write(out+'\n')
	else:
		print(out)
	ymstat = {}
	for dir in target_dirs:
		# points, photos = loadInputData(os.path.join(dir, 'maps.files'))
		vars = loadVars(os.path.join(dir, 'maps.files'))
		if 'StartDateTime' in vars:
			# StartDateTimeがある場合のみ

			# 平均速度による自動車・登山判定
			iscar = False
			if 'car' in vars:
				iscar = vars['car']
			else:
				vel = vars['AvgSpeed']
				iscar = vel >= CarVelocity

			if args.only_car:
				if not iscar:
					continue
			if args.except_car:
				if iscar:
					continue

			keys = ['StartDateTime', 'EndDateTime', 'MovingTime', 'ActualMovingTime', 'MoveDistance', 'TotalUp', 'TotalDown', 'CourseConst', 'CourseTime', 'kcal', 'TotalCost', 'ActualAvgSpeed', 'AvgSpeed', 'RelAlt', 'MaxAlt', 'MinAlt', 'TotalAlt', 'TotalUpTime', 'TotalDownTime', 'TotalUpDistance', 'TotalDownDistance', 'TotalUpAvg', 'TotalDownAvg', 'NumOfPeaks', 'TimeRatio', 'TimeRatioPerc', 'ActualTimeRatio', 'ActualTimeRatioPerc']
			dir = dir.replace('.\\', '')	# .\の削除
			out = '<a href="'+dir+'">'+dir+'</a>'
			if 'YamapUrl' in vars:
				out += ' <a href="'+vars['YamapUrl']+'">[Y]</a>'
			out += ','
			if dir in titles:
				out += titles[dir]
			for key in keys:
				if key in vars:
					s = str(vars[key])
					s = s.replace(',', '')
				else:
					s = ''
				out += ',' + str(s)
			if args.output:
				f.write(out+'\n')
			else:
				print(out)
			
			# 月ごとの統計情報
			# vars['StartDateTime'] = 2021/01/03 08:30
			if args.month:
				dt = vars['StartDateTime']
				# 2021/01/03 08:30 から年月を抽出
				year_month = re.match(r'(\d{4})/(\d{2})', dt)
				if year_month:
					year, month = year_month.groups()
					ymkeys = ['MoveDistance', 'TotalUp', 'TotalDown', 'TotalAlt', 'TotalCost', 'kcal']
					# print(f'{year=}, {month=}')
					if not year in ymstat:
						ymstat[year] = {}
					if not month in ymstat[year]:
						ymstat[year][month] = {'count': 0}
					ymstat[year][month]['count'] += 1
					for key in ymkeys:
						if key in vars:
							if not key in ymstat[year][month]:
								ymstat[year][month][key] = 0
							val = decomma(vars[key])
							ymstat[year][month][key] += val

		# parse comment.txt
		r, RPhotoNames, RTitle, RComment, MarkedFiles = t2g3lib.parseCommentFile(os.path.join(dir, 'comment.txt'))
		if r:
			name = 'cost'
			if name in RComment:
				lines = RComment[name].split("\n")
				# 合計金額を求める
				(total, rows) = t2g3lib.parseCost(lines)
				# if total > 0:
				# 	print("{} cost={}".format(dir, total))
				total_cost += total

	if args.output:
		f.close()

	if args.month:
		# min_year = 9999
		# max_year = 0
		# for year in ymstat:
		# 	if int(year) < min_year:
		# 		min_year = int(year)
		# 	elif int(year) > max_year:
		# 		max_year = int(year)

		f = open(args.month, mode='w', encoding='utf-8')
		f.write("Year,Month,Count,MoveDistance,TotalUp,TotalDown,TotalAlt,TotalCost,kcal\n")

		for year in ymstat:
			for mon in ymstat[year]:
				f.write(f'{year},{mon},{ymstat[year][mon]["count"]},{ymstat[year][mon]["MoveDistance"]},{ymstat[year][mon]["TotalUp"]},{ymstat[year][mon]["TotalDown"]},{ymstat[year][mon]["TotalAlt"]},{ymstat[year][mon]["TotalCost"]},{ymstat[year][mon]["kcal"]}\n')
		
		f.close()

	if args.month_graph:
		# 月ごとの統計情報をグラフにしてpngファイル出力
		import matplotlib.pyplot as plt
		# Prepare data for plotting
		months = []
		move_distances = []
		total_ups = []
		total_downs = []
		total_alts = []
		total_costs = []
		kcals = []
		total_counts = []

		for year in ymstat:
			for month in ymstat[year]:
				months.append(f'{year}/{month}')
				move_distances.append(ymstat[year][month]['MoveDistance'])
				total_ups.append(ymstat[year][month]['TotalUp'])
				total_downs.append(ymstat[year][month]['TotalDown'])
				total_alts.append(ymstat[year][month]['TotalAlt'])
				total_costs.append(ymstat[year][month]['TotalCost'])
				kcals.append(ymstat[year][month]['kcal'])
				total_counts.append(ymstat[year][month]['count'])

		# Plotting
		fig, axs = plt.subplots(7, 1, figsize=(15, 30))
		axs = axs.flatten()

		axs[0].bar(months, move_distances, color='b')
		axs[0].set_title('Move Distance')
		axs[0].set_xlabel('Month')
		axs[0].set_ylabel('Distance [km]')

		axs[1].bar(months, total_ups, color='g')
		axs[1].set_title('Total Up')
		axs[1].set_xlabel('Month')
		axs[1].set_ylabel('Altitude [m]')

		axs[2].bar(months, total_downs, color='r')
		axs[2].set_title('Total Down')
		axs[2].set_xlabel('Month')
		axs[2].set_ylabel('Altitude [m]')

		axs[3].bar(months, total_alts, color='c')
		axs[3].set_title('Total Alt')
		axs[3].set_xlabel('Month')
		axs[3].set_ylabel('Altitude [m]')

		axs[4].bar(months, total_costs, color='m')
		axs[4].set_title('Total Cost')
		axs[4].set_xlabel('Month')
		axs[4].set_ylabel('Cost [yen]')

		axs[5].bar(months, kcals, color='y')
		axs[5].set_title('Calories')
		axs[5].set_xlabel('Month')
		axs[5].set_ylabel('kcal')

		axs[6].bar(months, total_counts, color='k')
		axs[6].set_title('Days')
		axs[6].set_xlabel('Month')
		axs[6].set_ylabel('Days')

		for ax in axs:
			ax.grid(True)
			ax.tick_params(axis='x', rotation=45)

		plt.tight_layout()

		# Save the plot as a PNG file
		plt.savefig(args.month_graph)
		plt.close()

	if args.month_graph and False:
		# Graph
		import matplotlib.pyplot as plt

		# 年ごとの統計情報
		# ymstat[year][month][key]
		# key = 'count', 'MoveDistance', 'TotalUp', 'TotalDown', 'TotalAlt', 'TotalCost', 'kcal'
		# print(ymstat)

		# 年ごとの統計情報を集計
		yearstat = {}
		for year in ymstat:
			if not year in yearstat:
				yearstat[year] = {'count': 0, 'MoveDistance': 0, 'TotalUp': 0, 'TotalDown': 0, 'TotalAlt': 0, 'TotalCost': 0, 'kcal': 0}
			for mon in ymstat[year]:
				yearstat[year]['count'] += ymstat[year][mon]['count']
				yearstat[year]['MoveDistance'] += ymstat[year][mon]['MoveDistance']
				yearstat[year]['TotalUp'] += ymstat[year][mon]['TotalUp']
				yearstat[year]['TotalDown'] += ymstat[year][mon]['TotalDown']
				yearstat[year]['TotalAlt'] += ymstat[year][mon]['TotalAlt']
				yearstat[year]['TotalCost'] += ymstat[year][mon]['TotalCost']
				yearstat[year]['kcal'] += ymstat[year][mon]['kcal']

		# print(yearstat)

		# 年ごとの統計情報をグラフ表示
		fig, ax = plt.subplots()
		# ax.set_title('Monthly Statistics')
		ax.set_title('Yearly Statistics')
		ax.set_xlabel('Year')
		ax.set_ylabel('Value')

		# x = [f'{year}/{mon}' for year in ymstat for mon in ymstat[year]]
		x = [year for year in yearstat]
		# y = [ymstat[year][mon]['MoveDistance'] for year in ymstat for mon in ymstat[year]]
		y = [yearstat[year]['MoveDistance'] for year in yearstat]
		ax.plot(x, y, label='MoveDistance')
		

	print("Cost={}円".format(comma(total_cost)))

# almost same function as defined in t2g3.py
def loadInputData(dir):
	with open(dir+'/points.json', 'r') as f:
	    points = json.load(f)
	with open(dir+'/photos.json', 'r') as f:
	    photos = json.load(f)

	# str -> DataTime conversion
	for pt in points:
		pt['time'] = str2datetime(pt['time'])
	for photo in photos:
		if 'time' in photo:
			photo['time'] = str2datetime(photo['time'])

	return points, photos

def loadVars(dir):
	file = dir+'/vars.json'
	if not os.path.exists(file):
		vars = {}
		return vars
	with open(file) as f:
		vars = json.load(f)
	return vars

def read_index(file):
	titles = {}
	for line in open(file, encoding='utf-8'):
		m = re.search(r'.+a href="(\d+)">(.+?)</a>', line, re.I)
		if m:
			dir = m.group(1)
			title = m.group(2)
			title = re.sub(r'<[^>]+>', '', title)	# tag除去
			title = re.sub(r'^[\d\/\-,]+ +', '', title)	# 先頭の日付削除
			if '周回' in title:
				print("dir={} title={}".format(dir, title))
			titles[dir] = title
	return titles

#
# Helpers
#

def str2datetime(str):
	try:
		return datetime.datetime.strptime(str, "%Y-%m-%dT%H:%M:%S%z")
	except:
		return datetime.datetime.strptime(str, "%Y-%m-%dT%H:%M:%S.%f%z")

def comma(val):
	return '{:,}'.format(val)

def decomma(val):
	if val == '-':
		return 0
	if type(val) == int or type(val) == float:
		return val
	s = val.replace(',', '')
	if '.' in s:
		return float(s)
	return int(s)

main()
