#
# 引数にディレクトリ名を指定、複数指定可能
#
# 以下の２つのファイルの更新を１秒おきに監視する。
#  - 指定したディレクトリ名+comment.txt
#  - 指定したディレクトリ名+photos.md
# 更新があったかどうかは、ファイルのtimestampで判断する。
# 上記２つのファイルのうち、いずれかに更新されたファイルがあれば、次のコマンドを実行する。 
# mp.bat build_ディレクトリ名
#

import os
import sys
import time
import subprocess

CommentFile = 'comment.txt'
PhotosMD = 'photos.md'

def main():
	if len(sys.argv) < 2:
		print("usage: waitupd.py dir1 [dir2 ...]")
		sys.exit(1)

	dirs = sys.argv[1:]

	comment_timestamps = {}
	photos_timestamps = {}

	print(f'Waiting ... {dirs}')
	while True:
		for d in dirs:
			if not os.path.exists(d):
				print(f'Not exists {d}')
				return
			comment = os.path.join(d, CommentFile)

			changed = False

			if comment in comment_timestamps:
				ts = comment_timestamps[comment]
				ts = check_timestamp(comment, ts)
				if ts:
					changed = True
					comment_timestamps[comment] = ts
			else:
				ts = check_timestamp(comment, None)
				comment_timestamps[comment] = ts

			photos = os.path.join(d, PhotosMD)
			if os.path.exists(photos):
				if photos in photos_timestamps:
					ts = photos_timestamps[photos]
					ts = check_timestamp(photos, ts)
					if ts:
						changed = True
						photos_timestamps[photos] = ts
				else:
					ts = check_timestamp(photos, None)
					photos_timestamps[photos] = ts

			if changed:
				print("update detected in", d)
				subprocess.run(["mp.bat", "build_" + d])
				break
		time.sleep(0.1)

def check_timestamp(file, oldts):
	ts = os.path.getmtime(file)
	if ts != oldts:
		return ts
	return None

main()

