#
# backup用にcommen.txtをzipする
#

import os
import glob
import re
from zipfile import ZipFile

zipname = 'comment.zip'

cmtfiles = []

dirs = glob.glob('*')
for dir in dirs:
	if os.path.isdir(dir):
		if re.search(r'\d\d\d\d\d\d\d\d', dir):
			cmtfile = os.path.join(dir, 'comment.txt')
			if os.path.exists(cmtfile):
				print(cmtfile)
				cmtfiles.append(cmtfile)
			cmtfile = os.path.join(dir, 'photos.md')
			if os.path.exists(cmtfile):
				print(cmtfile)
				cmtfiles.append(cmtfile)
			files = glob.glob(dir + '/*.gpx')
			if len(files):
				cmtfiles.extend(files)
			files = glob.glob(dir + '/*.log')
			if len(files):
				cmtfiles.extend(files)

# if os.path.exists(zipname):
# 	os.remove(zipname)

with ZipFile(zipname, 'w') as zf:
	for file in cmtfiles:
		zf.write(file)

