// Generated by t2g3 ( http://pdic.la.coocan.jp/ )
// 本コードはt2g3によって自動生成されました。
// for Google Mpas APIv3


var numofwaypoints = 0;
var posofwaypoints = 0;
var numofphotos = $(NumOfPhotos);
var posofphotos = 0;
var waypoint_markers = [];
var waypoint_infos   = [];
var photo_markers    = [];
var photo_infos      = [];
var points = [];
var map;
var currentzoom;
var key = "$(GoogleMapKey)";
var gcurrent;
var jsondata;

var movemarkerIcon;
var streetObj;
var timerID2;
var timerID3;
   
// グラフマウスオーバ用のJavaScript
if (document.images)
{
	// 時刻－高度
	var alt = new Image();
	alt.src = "maps.files/time-alt.png";

	// 時刻－距離
	var dist = new Image();
	dist.src = "maps.files/time-dst.png";

	// 時刻－速度
	var speed = new Image();
	speed.src = "maps.files/time-speed.png";

	// 距離－高度
	var d_alt = new Image();
	d_alt.src = "maps.files/dist-alt.png";
}

// マウスオーバ時
function On(name) 
{
	if (document.images) 
	{
		document.images['graphimage'].src = eval(name + '.src');
	}
}

// ウェイポイント表示用関数
function addWayPoints(map, nType, lat, lon, title)
{
	var point=new google.maps.LatLng(lon, lat);
	var nn;
	if (nType==1){ // 小さな赤いマーカ
		nn=posofphotos+1;

		var properties = {
			position: point,
			map: map,
			title:"Waypoint Marker",
//			icon:"https://labs.google.com/ridefinder/images/mm_20_red.png",	// 小マーカー
			icon:"https://maps.google.com/mapfiles/ms/micons/red.png",		// バルーン
			shadow:"https://labs.google.com/ridefinder/images/mm_20_shadow.png"
		};
		var marker = new google.maps.Marker(properties);
	
		photo_markers.push(marker);
		photo_infos.push('<div style="width: 12em; style: font-size: small">'+title+'</div>');
		if (map != null){
			google.maps.event.addListener(photo_markers[posofphotos], "click", function(){jumpphotomarker(nn);});
			photo_markers[posofphotos].setMap(map);
		}
		posofphotos = posofphotos+1;

	} else if (nType >= 10 && nType <= 29){	// バルーン - 10-17
		// 10: blue, 11: red, 12: green, 13: lightblue, 14: yellow, 15: violet, 16: pink, 17: orange
		nn = posofwaypoints + 1;

		var color;
		switch (nType) {
			// ref. https://www.single-life.tokyo/google-maps%EF%BC%88%E3%82%B0%E3%83%BC%E3%82%B0%E3%83%AB%E3%83%9E%E3%83%83%E3%83%97%EF%BC%89%E3%81%A7%E4%BD%BF%E3%81%88%E3%82%8B%E3%82%A2%E3%82%A4%E3%82%B3%E3%83%B3/
			// バルーン
			case 10: color = "blue"; break;
			case 11: color = "red"; break;
			case 12: color = "green"; break;
			case 13: color = "lightblue"; break;
			case 14: color = "yellow"; break;
			case 15: color = "purple"; break;
			case 16: color = "pink"; break;
			case 17: color = "orange"; break;

			// 小マーカー
			case 20: color = "purple"; break;
			case 21: color = "yellow"; break;
			case 22: color = "blue"; break;
			case 23: color = "white"; break;
			case 24: color = "green"; break;
			case 25: color = "red"; break;
			case 26: color = "black"; break;
			case 27: color = "orange"; break;
			case 28: color = "gray"; break;
			case 29: color = "brown"; break;
			default: color = "blue"; break;
		}
		var icon_url = "https://maps.google.com/mapfiles/ms/micons/" + color + ".png";	// バルーン
		if (nType >= 20){
			icon_url = "https://labs.google.com/ridefinder/images/mm_20_" + color + ".png";	// 小マーカー
		}

		var properties = {
			position: point,
			map: map,
			title: "Waypoint Marker",
			icon: icon_url,
			shadow: "https://www.google.com/mapfiles/shadow50.png",
		};
		var marker = new google.maps.Marker(properties);

		waypoint_markers.push(marker);
		waypoint_infos.push('<div style="width: 12em; style: font-size: small">' + title + "</div>");
		if (map != null) {
			google.maps.event.addListener(waypoint_markers[posofwaypoints], "click", function () {jumpwaypointmarker(nn);});
			waypoint_markers[posofwaypoints].setMap(map);
		}
		posofwaypoints = posofwaypoints + 1;
	} else {	// |>の形状のマーカ
		nn=posofwaypoints+1;

		var properties = {
			position: point,
			map: map,
			title:"Waypoint Marker",
			icon:"https://www.google.com/mapfiles/dd-start.png",
			shadow:"https://www.google.com/mapfiles/shadow50.png"
		};
		var marker = new google.maps.Marker(properties);
	
		waypoint_markers.push(marker);
		waypoint_infos.push('<div style="width: 12em; style: font-size: small">'+title+'</div>');
		if (map != null){
			google.maps.event.addListener(waypoint_markers[posofwaypoints], "click", function(){jumpwaypointmarker(nn);});
			waypoint_markers[posofwaypoints].setMap(map);
		}
		posofwaypoints=posofwaypoints+1;
	}
}

// 写真表示モードロード時	
function photo_load()
{
	InitStreetView();
	AddAllWaypoints();
}
// ウェイポイント追加
function AddAllWaypoints()
{
$(WayPoints)

	return;
}
// ストリートビュー初期化
function InitStreetView()
{
}

async function initMap() {
	// 初期化パラメータ
	var mapwidth = $(MapWidth);  // 地図の幅を設定します。
	var mapheight = $(MapHeight); // 地図の高さを設定します。
	var zoom=-1;    // この値を変更すると初期ズーム値が変わります。-1の場合は自動となります。
	var defaultmaptype=0; // この値を変更すると初期のマップタイプが変更されます。
	var wpt_points = [];
	
	var region = new google.maps.LatLngBounds( new google.maps.LatLng($(RegionTop), $(RegionLeft)), new google.maps.LatLng($(RegionBottom),$(RegionRight)) );
	var centerpos= region.getCenter();
	
	// マップ初期化	
	var _zoom = zoom;
	if (zoom>0)	{
		_zoom = 17-zoom;
	}

	// 初期マップタイプ設定
	var mapTypeId = google.maps.MapTypeId.ROADMAP;
	switch(defaultmaptype) {
		case 1:
		// map.setMapType(G_SATELLITE_MAP); //This map type shows Google Earth satellite images.
		mapTypeId = google.maps.MapTypeId.SATELLITE;
		break;
	
		case 2:
		// map.setMapType(G_HYBRID_MAP); 	//This map type shows transparent street maps over Google Earth satellite images.
		mapTypeId = google.maps.MapTypeId.HYBRID;
		break;
		
		case 3:
		// map.setMapType(G_PHYSICAL_MAP);
		mapTypeId = google.maps.MapTypeId.TERRAIN;
		break;		
	}

	var mapOptions = {
        zoom: _zoom,
        center: centerpos,
        scaleControl: true,
        overviewMapControl: true,
        overviewMapControlOptions:{opened:true},
        mapTypeId: mapTypeId,
        gestureHandling: "greedy",
	};

	const { Map } = await google.maps.importLibrary("maps");

	map = new Map(document.getElementById("map"), mapOptions);

	if (zoom <= 0){
		map.fitBounds(region);
	}
	InitStreetView();
	AddAllWaypoints();

	if (numofwaypoints == 0) {
		hiddenLAYER("waypointcombo");
	}
	if (numofphotos == 0) {
		hiddenLAYER("photocombo");
	}
	if (callHiddenLayers == 1) {
		hiddenLayers();
	}
	
    XDownloadUrl(relativepathtosubfolder + "data.json", loadTrackLog);
}

// HTMLロード時
function load()
{
	initMap();
} // end of load() function.


var polylineid;
// トラックログ情報のロード
function loadTrackLog(jsontext, statusCode)
{
    if (statusCode != 200 && statusCode != 0)
    {
        alert("Reading json file failed :" +statusCode.toString());
        return;
    }
    jsondata = jsontext;
	if (jsondata["encoded_points"] != null){
        polylineid=0;
	    setTimeout(loadEncodedPolylines, 17);
	}
}

// Polylineを描画する。
function loadEncodedPolylines()
{
	var decodedPath = google.maps.geometry.encoding.decodePath(jsondata["encoded_points"][polylineid]);
//	var decodedLevels = decodeLevels(jsondata["encoded_levels"][polylineid]);

	var polyline = new google.maps.Polyline({
        path: decodedPath,
//        levels: decodedLevels,
        strokeColor: jsondata.linecolors[polylineid],
        strokeOpacity: jsondata.lineopacities[polylineid],
		strokeWeight: jsondata.linewidth[polylineid],
		zoomFactor: 4,
//		numLevels: 9,
        map: map
    });
	polylineid++;
	if (jsondata["encoded_points"].length > polylineid)
	{
	    setTimeout(loadEncodedPolylines, 17); // 33msec毎に制御を一旦返す。
	}
}

// トラッキング用API
var moveMarker;
var obj2;
var strStart ="開始";
var strStop = "始点へ";
var strPause ="一時停止";
// トラッキング操作
function operateTracking(obj) 
{
	if(obj.value == strStart)
	{
		obj.value = strPause;
		panTo(strStart, obj);
		obj2 = obj;
	}
	else if (obj.value == strPause)
	{
		panTo(strPause, obj);
		obj2 = obj;
	}
	else if (obj.value == strStop)
	{
		panTo(strStop, obj);
		if (obj2) obj2.value=strStart;
	}
	else
	{
		obj.value="";
	}
}
    
var iCurrent=0;
var timerID;
// 移動
function panTo(state, obj)
{

	if (state==strStart)
	{
		if (iCurrent>=jsondata.points.length)
		{
			obj.value=strStart;
			panTo(strStop, obj);
			return;
		}
		
	    gcurrent = new google.maps.LatLng(jsondata.points[iCurrent][0], jsondata.points[iCurrent][1]);
		map.panTo(gcurrent);
		if (moveMarker == null)
		{
			var properties = {
				position: gcurrent,
				map: map,
				title: "Move Marker",
				icon: "https://maps.google.co.jp/mapfiles/ms/icons/hospitals.png",
				shadow: "https://maps.google.co.jp/mapfiles/ms/icons/hospitals.shadow.png"
			};
			moveMarker = new google.maps.Marker(properties);
			moveMarker.setMap(map)
		}
		else
		{
			moveMarker.setLatLng(gcurrent);
		}
		var nstep=jsondata.points.length/30; //(30 = 2000msec/60000);
		if (iCurrent % nstep >= 1 && iCurrent % nstep < 2)
		{
			// 約2秒毎にストリートビューを表示
		    moveSVLocation(iCurrent);
		}

		iCurrent++;
		if (timerID != null) window.clearTimeout(timerID);
		timerID = window.setTimeout(function(){ panTo(strStart, obj); }, 60000/jsondata.points.length);
		if (iCurrent==jsondata.points.length)
		{
			obj.value=strStart;
			panTo(strStop, obj);
		}
	}
	else if (state==strStop)
	{
		iCurrent=0;
		gcurrent = new google.maps.LatLng(jsondata.points[iCurrent][0], jsondata.points[iCurrent][1]);
		
		if (moveMarker == null)
		{
			var properties = {
				position: gcurrent,
				map: map,
				title: "Move Marker",
				icon: "https://maps.google.co.jp/mapfiles/ms/icons/hospitals.png",
				shadow: "https://maps.google.co.jp/mapfiles/ms/icons/hospitals.shadow.png"
			};
			moveMarker = new google.maps.Marker(properties);
			moveMarker.setMap(map)
		}
		else
		{
			moveMarker.setLatLng(gcurrent);
		}
	    moveSVLocation(iCurrent);
		map.panTo(gcurrent);
		if (timerID != null) window.clearTimeout(timerID);
	}
	else
	{
		obj.value = strStart;
		if (timerID != null) window.clearTimeout(timerID);
	}
}	

// ストリートビュー表示設定(トラックログ)
function moveSVLocation(i) 
{
    gcurrent = new google.maps.LatLng(jsondata.points[iCurrent][0], jsondata.points[iCurrent][1]);
    var gnext = new google.maps.LatLng(jsondata.points[iCurrent+1][0], jsondata.points[iCurrent+1][1]);
    var gspecified = new google.maps.LatLng(jsondata.points[i][0], jsondata.points[i][1]);
    
    var spov = { yaw: 180, pitch: 0, zoom: 0 };
    var x = gnext.latRadians() - gcurrent.latRadians();
    var y = gnext.lngRadians() - gcurrent.lngRadians();
    yaw = 90 - Math.atan2(x, y) * 180 / Math.PI;
    if (yaw < 0) 
    {
	    yaw += 360;
	}
	spov.yaw = yaw;
	if (streetObj != null) 
	{
	    streetObj.setLocationAndPOV(gspecified, spov);
	    timerID2 = window.setTimeout(function() { streetObj.show(); clearTimeout(timerID2); }, 500);  // 少しディレイさせて表示更新
	}

	// 全画面表示時にinfoウインドウの高さを変更
	var obj;
	if (document.getElementById) obj = document.getElementById("info");
	if (obj == null && document.all) obj = document.all("info"); // Ie6対策
	if (obj != null) obj.style.bottom = "235px";
}

// ストリートビュー表示設定(フォト・ウェイポイントマーカ)
function moveSVLocationLatLon(latlon) 
{
    if (streetObj != null) 
    {
        streetObj.setLocationAndPOV(latlon);
	    timerID2 = window.setTimeout(function() { streetObj.show(); clearTimeout(timerID2); }, 500);  // 少しディレイさせて表示更新
    }

	// 全画面表示時にinfoウインドウの高さを変更
	var obj;
	if (document.getElementById) obj = document.getElementById("info");
	if (obj == null && document.all) obj = document.all("info"); // Ie6対策
	if (obj != null) obj.style.bottom = "235px";
}

// 指定された写真へジャンプ
var infoWindow;
function jumpphotomarker(n)
{
    if (n < 1) return;

	var info = photo_infos[n-1];
	var marker = photo_markers[n-1];
	if (infoWindow != null) infoWindow.close();	// not allowed multi window
	infoWindow = new google.maps.InfoWindow();
	infoWindow.setContent(info);
	infoWindow.open(map, marker);
	location.hash="#googlemap";
    moveSVLocationLatLon(marker.getPosition());
}
	
// 指定されたマーカーへジャンプ
function jumpwaypointmarker(n)
{
	var info = waypoint_infos[n-1];
	var marker = waypoint_markers[n-1];
	if (infoWindow != null) infoWindow.close();	// not allowed multi window
	infoWindow = new google.maps.InfoWindow();
	infoWindow.setContent(info);
	infoWindow.open(map, marker);
	location.hash="#googlemap";
	moveSVLocationLatLon(marker.getPosition());
}

// グラフは初期状態では消しておく
function hiddenLayers()
{
	hiddenLAYER('graph1');
	hiddenLAYER('graph2');
	hiddenLAYER('graph3');
	hiddenLAYER('graph4');
}

// 指定したレイヤーを非表示にする
function hiddenLAYER(idName)
{ 
    if (idName == null)
    {
        // nullなら何もしない。
        return;
    }
	if ( document.getElementById )
	{
	    if (document.getElementById( idName ) == null)
	    {
	        return;
	    }
		document.getElementById( idName ).style.visibility='hidden';
	}
	else if ( document.all )
	{
	    if (document.all( idName ) == null) 
	    {
	        return;
	    }
		document.all( idName ).style.visibility = 'hidden';
	}
}

// 指定したレイヤーを表示する
function showLAYER(idName)
{
    if (idName == null)
    {
        // nullなら何もしない。
        return;
    }
    
    if ( document.getElementById )
	{
	    if (document.getElementById( idName ) == null)
	    {
	        return;
	    }
		document.getElementById( idName ).style.visibility   = 'visible';
	}
	else if ( document.all )
	{
	    if (document.all( idName ) == null) 
	    {
	        return;
	    }
		document.all( idName ).style.visibility = 'visible'; // Ie6対策
	}
}

// 地図を表示する
function showMapPop( idName, lat, lon )
{ 
    if (idName == null){
        return;
    }
	var svalue;
	var zoomlevel;
	var i = idName.slice(6);
	if (i < 1){
	    return;
	}
	moveSVLocationLatLon(photo_markers[Number(i) - 1].getPoint());
	
	if (map == null)
	{
		if (currentzoom == null)
		{
			zoomlevel=12; // 指定がない場合	
		}
		else
		{
			zoomlevel=currentzoom; // htmlファイルに?xxでズームレベルが渡されたとき
		}
	}
	else
	{
		zoomlevel=map.getZoom();
	}
	svalue = ".<img src=\"https://maps.google.com/maps/api/staticmap??center="+lat+","+lon+"&markers="+lat+","+lon+",blue&zoom="+zoomlevel+"&size=240x240&key="+key+"\" width=\"240\" height=\"240\"  />.";

	if ( document.getElementById )
	{
		document.getElementById( idName ).style.display="block";
		document.getElementById( idName ).innerHTML = svalue;
	}
	else if ( document.all ) 
	{
		 document.all( idName ).style.display="block"; // Ie6対策
		 document.all( idName ).innerHTML=svalue;
	}
	moveSVLocationLatLon(photo_markers[Number(i) - 1].getPoint());

}

// 地図を消す
function hideMapPop( idName )
{
	if ( document.getElementById )
	{
		document.getElementById( idName ).style.display="none";
	}
	else if ( document.all )
	{
		document.all( idName ).style.display="none"; // Ie6対策
	}
}

// ズームレベルを渡しながらページを移動する。
function goPhotopage(url, hash)
{
	location.href=url+"?"+map.getZoom()+hash;
}

(function($j){
    $j.positionFixed = function(el){
        $j(el).each(function(){
            new fixed(this)
        })
        return el;
    }
    $j.fn.positionFixed = function(){
        return $j.positionFixed(this)
    }
    var fixed = $j.positionFixed.impl = function(el){
        var o=this;
        o.sts={
            target : $j(el).css('position','fixed'),
            container : $j(window)
        }
        o.sts.currentCss = {
            top : o.sts.target.css('top'),
            right : o.sts.target.css('right'),
            bottom : o.sts.target.css('bottom'),
            left : o.sts.target.css('left')
        }
        if(!o.ie6)return;
        o.bindEvent();
    }
    $j.extend(fixed.prototype,{
        ie6 : false,
        bindEvent : function(){
            var o=this;
            o.sts.target.css('position','absolute')
            o.overRelative().initBasePos();
            o.sts.target.css(o.sts.basePos)
            o.sts.container.scroll(o.scrollEvent()).resize(o.resizeEvent());
            o.setPos();
        },
        overRelative : function(){
            var o=this;
            var relative = o.sts.target.parents().filter(function(){
                if($j(this).css('position')=='relative')return this;
            })
            if(relative.size()>0)relative.after(o.sts.target)
            return o;
        },
        initBasePos : function(){
            var o=this;
            o.sts.basePos = {
                top: o.sts.target.offset().top - (o.sts.currentCss.top=='auto'?o.sts.container.scrollTop():0),
                left: o.sts.target.offset().left - (o.sts.currentCss.left=='auto'?o.sts.container.scrollLeft():0)
            }
            return o;
        },
        setPos : function(){
            var o=this;
            o.sts.target.css({
                top: o.sts.container.scrollTop() + o.sts.basePos.top,
                left: o.sts.container.scrollLeft() + o.sts.basePos.left
            })
        },
        scrollEvent : function(){
            var o=this;
            return function(){
                o.setPos();
            }
        },
        resizeEvent : function(){
            var o=this;
            return function(){
                setTimeout(function(){
                    o.sts.target.css(o.sts.currentCss)
                    o.initBasePos();
                    o.setPos()
                },1)
            }
        }
    })
})(jQuery)

jQuery(function($j){
	$j('.fixed').positionFixed()
})
function XDownloadUrl(url, func)
{
	$.ajax({
	  url: url,
	  cache: false,
	  dataType: "json",
	}).done(function(data, status, xhr){
		func(data, xhr.status);
	}).fail(function(xhr, status, error){
		alert("failed "+xhr.status + " "+xhr.statusText+" "+url+" status="+status+" error="+error);
		});
}
// Decode an encoded levels string into an array of levels.
function decodeLevels(encodedLevelsString)
{
  var decodedLevels = [];

  for (var i = 0; i < encodedLevelsString.length; ++i) {
    var level = encodedLevelsString.charCodeAt(i) - 63;
    decodedLevels.push(level);
  }

  return decodedLevels;
}
