# /usr/bin/python3

# index.htmlにあるlink先のファイル名・ディレクトリ名の一覧を出力する
# 出力した一覧はupftp用として利用可能

import argparse
import os

add_exc_files = []	# 追加の除外ファイルのリスト

def main():
	parser = argparse.ArgumentParser(description="indexlink")
	parser.add_argument('index', help='index.html file')
	parser.add_argument('-oo', '--only_one', help='only one file', action='store_true')
	args = parser.parse_args()

	with open(args.index, mode='r', encoding='utf-8') as f:
		lines = f.readlines()

	links = []
	for line in lines:
		if 'href=' in line:
			i = line.find('href=')
			line = line[i+6:]
			i = line.find('"')
			line = line[:i]
			if len(line) == 0:
				continue
			if line.startswith('http'):
				continue
			if line.startswith('javascript:'):
				continue
			if line.startswith('#'):
				continue
			links.append(line)

	# for link in links:
	# 	print(link)

	# args.indexのディレクトリにあるファイル名を取得する（ディレクトリ名は除外）
	dirname = os.path.dirname(args.index)
	index_filename = os.path.basename(args.index)
	dirname2 = dirname
	if len(dirname) == 0:
		dirname2 = '.'
	files = os.listdir(dirname2)
	files = [f for f in files if os.path.isfile(os.path.join(dirname, f))]
	# filesのうち、linksに含まれているものを除外する
	exc_files = [f for f in files if f not in links and f != index_filename]
	# for f in exc_files:
	# 	print(f)

	# exc_filesを.ftpctrlファイルに出力する
	sections = read_ftpctl(dirname)
	exc_files.extend(add_exc_files)	# 追加の除外ファイルを追加する
	sections['exclude'] = exc_files
	write_ftpctl(dirname, sections)

	# linksの中から、ディレクトリ名を含むものだけを抽出する
	# 例）aaa(directory) -> aaa
	# 例）aaa/bbb/ccc.html -> aaa/bbb
	# odirs = {}
	dirs = []
	for link in links:
		# olink = link
		# odirs[olink] = ''
		if not os.path.isdir(os.path.join(dirname, link)):
			i = link.rfind('/')
			if i < 0:
				continue	# ディレクトリ名が無い場合は次へ
			link = link[:i]
			if not os.path.isdir(os.path.join(dirname, link)):
				continue	# ディレクトリではない場合は次へ
		dirs.append(link)
		# odirs[olink] = link

	# for d in odirs:
	# 	print(f'{d} -> {odirs[d]}')

	# 転送対象ディレクトリの一覧出力
	for d in dirs:
		if args.only_one:	# 一度に出力するとupftpに膨大な時間がかかるため、一つずつ出力する
			if not d.startswith('2024'):
				continue
		print(os.path.join(dirname, d)+'/*')

def read_ftpctl(dir):
	filename = os.path.join(dir, '.ftpctl')
	if not os.path.exists(filename):
		return {}
	with open(filename, mode='r', encoding='utf-8') as f:
		lines = f.readlines()
	# linesを[section]ごとの地所配列に変換する
	sections = {}
	for line in lines:
		if len(line) == 0:
			continue
		if line.startswith('['):
			# [section]の両側の[]を除去する
			section = line[1:-2]
			sections[section] = []
		else:
			sections[section].append(line.strip())
	return sections

def write_ftpctl(dir, sections):
	filename = os.path.join(dir, '.ftpctl')
	with open(filename,	mode='w', encoding='utf-8') as f:
		for section in sections:
			f.write('[' + section + ']\n')
			for line in sections[section]:
				f.write(line + '\n')

if __name__ == '__main__':
	main()
