#
#
# index.html または index2.html にある古いlightboxを新しいlightboxに置き換える。
# 古いindex.htmlは置き換えられれば index.html.oldにrename

import os
import re

def main():
	if not process('index.html'):
		if not process('index2.html'):
			print("No old lightbox in index(2).html")

def process(filename):
	if not os.path.exists(filename):
		return False

	print("processing... ", filename)

	exists = False
	try:
		for line in open(filename, encoding='utf_8_sig'):
			if '../lightbox/' in line:
				exists = True
				break
	except UnicodeDecodeError as e:
		print(e)
		print("Enter to proceed if OK?")
		input()
		return False
	
	if not exists:
		return False

	replaced = False
	newfile = filename + '.new'
	with open(newfile, "w", encoding='utf_8_sig') as fw:
		for line in open(filename, encoding='utf_8_sig'):
			r = re.search(r'<(\w+).+/lightbox/([\w.]*)', line)
			if r:
				# print(f"script={r.group(1)} file={r.group(2)}")
				if r.group(1) == 'script' and r.group(2) == 'lightbox_plus.js':
					print("found: ", line)
					line = re.sub(r'/lightbox/', '/lightboxplus/', line)
					fw.write(line)
					replaced = True
				# 上記以外は捨てる
				continue
			fw.write(line)

	if replaced:
		oldfile = filename + '.old'
		if os.path.exists(oldfile):
			os.remove(oldfile)
		os.rename(filename, oldfile)					
		os.rename(newfile, filename)

	return replaced


main()
