import re
import os

def parseCommentFile(file, encoding='utf8', no_br=False):
	RPhotoNames = []	# comment.txtから取得したphoto nameなど
	RTitle = {}
	RComment = {}
	MarkedFiles = []

	if not os.path.exists(file):
		print("open parseCommentFile error:", file)
		return False, RPhotoNames, RTitle, RComment, MarkedFiles

	ret = True

	try:
		state = 0
		multiline = False	# $$による複数行
		for line in open(file, encoding=encoding):
			line = line.rstrip('\n')

			if len(line) == 0 and not multiline:
				state = 0
				basename = ''
				continue

			if state == 0:
				if line[0] == '<':	# いずれ削除
					basename = line[1:]
					MarkedFiles.append(basename)
				elif line.endswith('>'):
					basename = line[:-1]
					MarkedFiles.append(basename)
				elif line.endswith('*'):
					basename = line[:-1]
					RTitle[basename] = '*'	# 非表示対象
				elif line.startswith('include '):
					r = re.search(r'include (.+)', line)
					if r:
						dir, base = os.path.split(file)
						includefile = os.path.join(dir, r.group(1))
						includeCommentFile(includefile, RPhotoNames, RTitle, RComment, MarkedFiles, encoding)
					else:
						raise 'No include file?'
				else:
					basename = line
				state += 1
				RPhotoNames.append(basename)
			else:
				if not basename in RTitle:
					# print("title=", line)
					RTitle[basename] = line
					if line.startswith('$$'):
						multiline = True
				else:
					# print("{}: comment={}".format(basename, line))
					# 改行のみ
					if line == " " or line == "　" or line == "\\":
						line = ''
					if basename in RComment:
						if no_br:
							RComment[basename] += "\n"
						else:
							RComment[basename] += "\n"
					else:
						RComment[basename] = ''
					RComment[basename] += line
					# 複数行対応
					if line.startswith('$$'):
						if multiline:
							multiline = False
						else:
							multiline = True
	except UnicodeDecodeError:
		# SJIS? retry as default
		return parseCommentFile(file, encoding=None)

	return ret, RPhotoNames, RTitle, RComment, MarkedFiles

def includeCommentFile(file, RPhotoNames, RTitle, RComment, MarkedFiles, encoding='utf8'):
	base, ext = os.path.splitext(file)
	if ext.lower() == '.md':
		convertMarkdown(file, base+'.txt')
		file = base+'.txt'
	ret, rphotonames, rtitle, rcomment, markedfiles = parseCommentFile(file, encoding)
	RPhotoNames.extend(rphotonames)
	RTitle.update(rtitle)
	RComment.update(rcomment)
	MarkedFiles.extend(markedfiles)
	return ret

# markdown -> comment.txt file format
def convertMarkdown(file, txt, encoding='utf8'):
	wf = open(txt, mode='w')
	photoline = False
	title = None
	title_lines = []
	last_title_line = False
	nodisp = False
	redirect = False
	for line in open(file, encoding=encoding):
		line = line.rstrip('\n')
		if photoline:
			# photo nameだけの行（のはず）
			photoline = False

			if line.endswith('>'):
				redirect = True

			# photo lineの出力
			if nodisp:
				photo += '*'
			if redirect:
				photo += '>'
			wf.write(photo+'\n')
			if title:
				wf.write('!'+title+'\n')

				# 最後の空行を削除
				while len(title_lines) > 0:
					if len(title_lines[-1]) != 0:
						break
					title_lines = title_lines[:-1]

				if len(title_lines):
					wf.write('$$')
					for l in title_lines:
						if len(l) == 0:
							wf.write(" \n")
						else:
							wf.write(l+"\n")
					last_title_line = True

			title = None
			title_lines = []
			nodisp = False
			redirect = False
			continue

		r = re.match(r'!\[\]\((.+)\.jpg(.*)\)', line)
		if r:
			# 写真
			photo = r.group(1)
			if line.endswith('*') or r.group(2) == '*':
				nodisp = True
			if line.endswith('>'):
				redirect = True
			photoline = True
		else:
			r = re.match(r'#+ (.+)', line)
			if r:
				# 見出し
				title = r.group(1)
			else:
				if title:
					# titlaの説明
					if len(title_lines) > 0 or len(line) > 0:
						title_lines.append(line)
				else:
					if last_title_line and len(line)>0:
						wf.write("$$\n")
					# そのまま出力
					wf.write(line+"\n")
		last_title_line = False

def parseCost(lines, err_if_exists=False):
	total = 0
	total_exists = False	# 合計項目が存在する場合はそれをそのまま返す
	rows = 0
	for line in lines:
		items = line.split("\t")
		if items[0] == '合計':
			if err_if_exists:
				total = -1	# already exists
				break
			total_exists = True

		if len(items) >= 3:
			price = items[2]
			price = re.sub(r'[,?]', '', price)
			price = re.sub(r'<br>', '', price)
			tax = False
			org_price = price

			header = False
			if price == '金額':
				header = True

			if '+税' in price:
				tax = True
				price = price.replace('+税', '')
			if '+tax' in price:
				tax = True
				price = price.replace('+tax', '')

			price = re.sub(r'^\\', '', price)	# 先頭の円マーク削除
			price = re.sub(r'円', '', price)	# 円削除

			m = re.match(r'[^\d]*(\d+)\s*x\s*([\d.]+)', price)
			if m:
				price = round(float(m.group(1)) * float(m.group(2)))
			try:
				price = eval(str(price))
			except:
				if not header:
					print("Warning: exception: ", price)
				pass

			if tax:
				tax_rate = 1.08
				price = round(price * tax_rate)

			# print(f'{org_price} -> {price}')

			if not header:
				rows += 1

			if total_exists:
				total = int(price)
				break

			try:
				total += int(price)
			except:
				pass

	return total, rows
